/****************************************************************
 * Template Name: AWS S3 File Uploader
 * Theme URL: https://codecanyon.net/user/berkinedesign/portfolio
 * Author: BerkineDesign
 * Author URL: https://codecanyon.net/user/berkinedesign
 * Version: 1.0
 * File name: custom.js;
 * Date Created: 25.11.2019
 * Website: www.berkinedesign.com
 ****************************************************************/


/* -------------------------------------------------------------- */
/*                      TABLE OF CONTENTS
/* -------------------------------------------------------------- */
/*   01 - VERIFY SINGLE FILE UPLOAD SIZE AND FILE EXTENSION       */
/*   02 - AJAX REQUEST FOR PASSING DATA TO PHP (SINGLE FILE)      */
/*   03 - VERIFY MULTIPLE FILES UPLOAD SIZES AND FILE EXTENSIONS  */
/*   04 - AJAX REQUEST FOR PASSING DATA TO PHP (MULTI FILE)       */
/*   05 - VERIFY MULTI-PART FILE UPLOAD SIZE AND FILE EXTENSION   */
/*   06 - AJAX REQUEST FOR PASSING DATA TO PHP (MULTIPART FILE)   */
/*   07 - TIME SLIDER FUNCTION                                    */
/*   08 - COPY TO CLIPBOARD FUNCTION                              */
/*   09 - ENABLE TOOLTIPS                                         */
/*   10 - INPUT FIELD                                             */
/*   11 - EMAIL SENDING BLOCK UNTIL FILE IS UPLOADED SUCCESSFULLY */
/*   12 - PARTICULES.JS BACKGROUD SCRIPT                          */
/*   13 - UPLOAD PROGRESS BAR                                     */
/*   14 - FILE DOWNLOAD BUTTONS                                   */
/*   15 - ACTIVE TAB PANE                                         */


/*===========================================================================
*
*  01 - VERIFY SINGLE FILE UPLOAD SIZE AND FILE EXTENSION
*
*============================================================================*/

$(document).ready(function() {

  "use strict";


  /* Disable Upload Submit button if no file has been selected */
	$("#upload-submit").prop("disabled", true).addClass("is-blocked");


  /* Verify file data when file has been selected */
	$('#file-single').on('change', function() {
		
		if ($("#upload-submit").prop('disabled',false)){
 	
 			$("#upload-submit").prop('disabled',true).addClass("is-blocked"); 
				
 		}


 		var fileMaxSize = 5242880;     /* Adjust the file size accordingly (5 MB for example) */
 		var fileSize = this.files[0].size;
 		var fileExtension = $('#file-single').val().split('.').pop().toLowerCase();


 		if (fileSize !== 'undefined') {

 			if (fileSize > fileMaxSize) {
 			
	 			var message = "Maximum allowed file size is 5MB. Selected file size is " + (fileSize/Math.pow(1024,2)).toFixed(0) +"MB.";
	 			
        showStatusMessageSingleUpload(message, 'error');
        
        $('#file-single').val('');

	 			return false;

 			} else if ($.inArray(fileExtension, ['exe', 'msi', 'bat', 'cmd', 'reg', 'jar']) !== -1) {

 				var message = "File with extention \"" + fileExtension + "\" is not allowed to be uploaded.";
 				
        showStatusMessageSingleUpload(message, 'error');
        
        $('#file-single').val('');
 
	 			return false;

 			} else {

        /* If file meets the requirements enable file upload button */
 				$("#upload-submit").prop('disabled',false).removeClass("is-blocked");

 			}


 		}
 		

	});

});


function showStatusMessageSingleUpload(message,status){
  
  "use strict";

  if (status == "success") {
      
      $("#single-upload-status-message").addClass("success-message").removeClass("error-message");
    
  } else if (status == "error") {
      
      $("#single-upload-status-message").removeClass("success-message").addClass("error-message");
  }

  $("#single-upload-status-message")
    .slideDown()
    .html(message)
    .delay(5000)
    .slideUp();

}



/*===========================================================================
*
*  02 - AJAX REQUEST FOR PASSING DATA TO PHP (SINGLE FILE)
*
*============================================================================*/

$(document).ready(function () {
    
    "use strict";


    $("#single-upload-form").on("submit",(function(e) {

         e.preventDefault();
       
         var formData = new FormData(this);
         
         $.ajax({
               type: "POST",
               url: "single-file-upload.php",
               data: formData,      
               contentType: false,
               processData: false,
               cache: false,
               
               success: function(response) {
                         
                  $("#file-upload-label").text('Choose a file...');              

                  $(".progress-bar").css("width", 0 + "%").text('');

               },

                error: function (response) {

                    console.log('There was an error.');

                    console.log(response);

                }

             }).done(function(response) {


                    parseSingleUploadResponse(response);
              
                    $('#file-single').val('');   

            })

      }));

    
});


function parseSingleUploadResponse(response) {

  "use strict";

  if ($("#radio-button-public").prop("checked")) {

      var link = response['public-url'];
      var message = response['message'];      
      var status = response['status'];      

      $("#public-link-value").val(link);
      $("#private-link-value").val('');
      $("#private-link-duration").text('');

      showStatusMessageSingleUpload(message,status);

  
  } else if ($("#radio-button-private").prop("checked")) {

      var link = response['private-url'];
      var link_duration = response['private-url-duration'];
      var message = response['message'];      
      var status = response['status']; 

      $("#private-link-value").val(link);
      $("#public-link-value").val('');
      $("#private-link-duration").text(link_duration);

      showStatusMessageSingleUpload(message,status);

  }

}



/*===========================================================================
*
*  03 - VERIFY MULTIPLE FILES UPLOAD SIZES AND FILE EXTENSIONS
*
*============================================================================*/

$(document).ready(function() {

  "use strict";

  /* Disable Upload Submit button if no file has been selected */
  $("#multi-upload-submit").prop("disabled", true).addClass("is-blocked");


  $('#file-multi').on('change', function() {
    
    if ($("#multi-upload-submit").prop('disabled',false)){
  
      $("#multi-upload-submit").prop('disabled',true).addClass("is-blocked"); 
        
    }


    var filesMaxTotalSize = 10485760; //10 MB in Total Size is allowed
    var filesMaxQuantity = 3; // 3 Files can be uploaded at the same time
    var filesQuantity = this.files.length;
    var filesTotalSize = 0;
    var restrictedFileType = false;
    var uploadedRestrictedExtension = '';


    //Check total size of the uploaded files
    for (var i = 0; i < this.files.length; i++) {
        
        filesTotalSize += this.files[i].size;

    }


    //Check for not supported file extensions
    for (var i = 0; i < this.files.length; i++) {
      
      var fileExtension = this.files[i].name.split('.').pop().toLowerCase();
      
      if($.inArray(fileExtension, ['exe', 'msi', 'bat', 'cmd', 'reg', 'jar']) !== -1) {
        
        restrictedFileType = true;
        
        uploadedRestrictedExtension = fileExtension;
        
        break;

      }

    }


    if (restrictedFileType) {

        var message = "File with extention \"" + uploadedRestrictedExtension + "\" is not allowed.";
        
        showStatusMessageMultiUpload(message, 'error');

        $('#file-multi').val('');

        return false;

    } else if (filesQuantity > filesMaxQuantity) {

        var message = "Maximum 3 files are allowed to be uploaded simultaneously. You are trying to upload " + filesQuantity +" files.";
      
        showStatusMessageMultiUpload(message, 'error');

        $('#file-multi').val('');
      
        return false;

    } else if (filesTotalSize > filesMaxTotalSize) {

        var message = "Maximum allowed total file size is 10MB. Selected files have " + (filesTotalSize/Math.pow(1024,2)).toFixed(0) +"MB of total size.";
      
        showStatusMessageMultiUpload(message, 'error');

        $('#file-multi').val('');
      
        return false;

    } else {

      $("#multi-upload-submit").prop('disabled',false).removeClass("is-blocked");

    }


  });

});


function showStatusMessageMultiUpload(message,status){
  
  "use strict";

  if (status == "success") {
      
      $("#multi-upload-status-message").addClass("success-message").removeClass("error-message");
    
  } else if (status == "error") {
      
      $("#multi-upload-status-message").removeClass("success-message").addClass("error-message");
  }

  $("#multi-upload-status-message")
    .slideDown()
    .html(message)
    .delay(5000)
    .slideUp();
}



/*===========================================================================
*
*  04 - AJAX REQUEST FOR PASSING DATA TO PHP (MULTI FILE)
*
*============================================================================*/

$(document).ready(function () {

    
    "use strict";


    $("#multi-upload-form").on("submit",(function(e) {

         e.preventDefault();
       
         var formData = new FormData(this);
         
         $.ajax({
               type: "POST",
               url: "multi-file-upload.php",
               data: formData,
               contentType: false,
               processData: false,
               cache: false,
                
               success: function(response) {
                
                  console.log(response);

                  $("#file-upload-label-multi").text('Choose a file...');                

                  $("#multi-progress-bar").css("width", 0 + "%").text('');

               },

                error: function (response) {

                    console.log('There was an error.');

                    console.log(response);
                
                }

             }).done(function(response) {


                parseMultiUploadResponse(response);
              
                $('#file-multi').val('');

          })
                
      
      }));

    
});


function parseMultiUploadResponse(response) {

  "use strict";

  if($("#radio-button-public-multi").prop("checked")) {

      var link = response['public-url'];
      var message = response['message'];      
      var status = response['status'];      

      $("#public-link-value-multi").text(link);
      $("#private-link-value-multi").text('');
      $("#private-link-duration-multi").text('');

      showStatusMessageMultiUpload(message,status);

  
  } else if($("#radio-button-private-multi").prop("checked")) {

      var link = response['private-url'];
      var link_duration = response['private-url-duration'];
      var message = response['message'];      
      var status = response['status']; 

      $("#private-link-value-multi").text(link);
      $("#public-link-value-multi").text('');
      $("#private-link-duration-multi").text(link_duration);

      showStatusMessageMultiUpload(message,status);

  }

}


/*===========================================================================
*
*  05 - VERIFY MULTI-PART FILE UPLOAD SIZE AND FILE EXTENSION
*
*============================================================================*/

$(document).ready(function() {

  "use strict";


  /* Disable Upload Submit button if no file has been selected */
  $("#upload-submit-multipart").prop("disabled", true).addClass("is-blocked");


  /* Verify file data when file has been selected */
  $('#multipart-file').on('change', function() {
    
    if ($("#upload-submit-multipart").prop('disabled',false)){
  
      $("#upload-submit-multipart").prop('disabled',true).addClass("is-blocked"); 
        
    }


    var fileMaxSize = 20971520;     /* Adjust the file size accordingly (20 MB for example) */
    var fileSize = this.files[0].size;
    var fileExtension = $('#multipart-file').val().split('.').pop().toLowerCase();


    if (fileSize !== 'undefined') {

      if (fileSize > fileMaxSize) {
      
        var message = "Maximum allowed file size is 20MB. Selected file size is " + (fileSize/Math.pow(1024,2)).toFixed(0) +"MB.";
        
        showStatusMessageMultiPartUpload(message, 'error');
        
        $('#multipart-file').val('');

        return false;

      } else if ($.inArray(fileExtension, ['exe', 'msi', 'bat', 'cmd', 'reg', 'jar']) !== -1) {

        var message = "File with extention \"" + fileExtension + "\" is not allowed to be uploaded.";
        
        showStatusMessageMultiPartUpload(message, 'error');
        
        $('#multipart-file').val('');
 
        return false;

      } else {

        /* If file meets the requirements enable file upload button */
        $("#upload-submit-multipart").prop('disabled',false).removeClass("is-blocked");

      }


    }
    

  });

});


function showStatusMessageMultiPartUpload(message,status){
  
  "use strict";

  if (status == "success") {
      
      $("#multipart-upload-status-message").addClass("success-message").removeClass("error-message");
    
  } else if (status == "error") {
      
      $("#multipart-upload-status-message").removeClass("success-message").addClass("error-message");
  }

  $("#multipart-upload-status-message")
    .slideDown()
    .html(message)
    .delay(5000)
    .slideUp();

}



/*===========================================================================
*
*  06 - AJAX REQUEST FOR PASSING DATA TO PHP (MULTIPART FILE)
*
*============================================================================*/

$(document).ready(function () {
    
    "use strict";


    $("#multi-part-upload-form").on("submit",(function(e) {

         e.preventDefault();
       
         var formData = new FormData(this);
         
         $.ajax({
               type: "POST",
               url: "multi-part-file-upload.php",
               data: formData,      
               contentType: false,
               processData: false,
               cache: false,
               
               success: function(response) {
                   
                  console.log(response);              
                  $("#file-upload-label-multipart").text('Choose a file...');              

                  $("#progress-bar-multipart").css("width", 0 + "%").text('');

               },

                error: function (response) {

                    console.log('There was an error.');

                    console.log(response);

                }

             }).done(function(response) {


                    parseMultiPartUploadResponse(response);
              
                    $('#multipart-file').val('');   

            })

      }));

    
});


function parseMultiPartUploadResponse(response) {

  "use strict";

  if ($("#radio-button-public-multipart").prop("checked")) {

      var link = response['public-url'];
      var message = response['message'];      
      var status = response['status'];      

      $("#public-link-value-multipart").val(link);
      $("#private-link-value-multipart").val('');
      $("#private-link-duration-multipart").text('');

      showStatusMessageMultiPartUpload(message,status);

  
  } else if ($("#radio-button-private-multipart").prop("checked")) {

      var link = response['private-url'];
      var link_duration = response['private-url-duration'];
      var message = response['message'];      
      var status = response['status']; 

      $("#private-link-value-multipart").val(link);
      $("#public-link-value-multipart").val('');
      $("#private-link-duration-multipart").text(link_duration);

      showStatusMessageMultiPartUpload(message,status);

  }

}

/*===========================================================================
*
*  07 - TIME SLIDER FUNCTION
*
*============================================================================*/

$(document).ready(function() {

  "use strict";

  /* Enable Custom Slider for selecting minutes*/
	$("#ex7").slider({
		tooltip: 'always',
		formatter: function(value) {
			return value + ' min';
		}
	});

	$("#ex7-enabled").on("click", function() {
		if(this.checked) {
		
			$("#ex7").slider("enable");

		}
		else {
			
			$("#ex7").slider("disable");

		}
	});

  $("#ex8").slider({
    tooltip: 'always',
    formatter: function(value) {
      return value + ' min';
    }
  });

  $("#ex8-enabled").on("click", function() {
    if(this.checked) {
      // With JQuery
      $("#ex8").slider("enable");

    }
    else {
      // With JQuery
      $("#ex8").slider("disable");

    }
  });

  $("#ex9").slider({
    tooltip: 'always',
    formatter: function(value) {
      return value + ' min';
    }
  });

  $("#ex9-enabled").on("click", function() {
    if(this.checked) {
      // With JQuery
      $("#ex9").slider("enable");

    }
    else {
      // With JQuery
      $("#ex9").slider("disable");

    }
  });


});



/*===========================================================================
*
*  08 - COPY TO CLIPBOARD FUNCTION
*
*============================================================================*/

$(document).ready(function() {

	function copyToClipboard(text) {

    "use strict";

	   var textArea = document.createElement( "textarea" );
	   textArea.value = text;
	   document.body.appendChild( textArea );

	   textArea.select();

   	 	try {
		      var successful = document.execCommand( 'copy' );
		      var msg = successful ? 'successful' : 'unsuccessful';
		
   		} catch (err) {
      		console.log(msg);
   		}

   			document.body.removeChild( textArea );
		}

/*----------------------------------------------*/
/*   Single File Upload Tab Copy Buttons
/*----------------------------------------------*/

	$( '#public-copy-btn' ).on("click", function() {

      "use strict";

	     var clipboardText = "";
	     clipboardText = $( '#public-link-value' ).val();
	     copyToClipboard( clipboardText );

	     $(this).tooltip('hide')
	      .attr('data-original-title', 'Copied')
	      .tooltip('show');
     
 	});


	$( '#private-copy-btn' ).on("click", function() {

      "use strict";

	     var clipboardText = "";
	     clipboardText = $( '#private-link-value' ).val();
	     copyToClipboard( clipboardText );

	     $(this).tooltip('hide')
	      .attr('data-original-title', 'Copied')
	      .tooltip('show');
     
 	});


/*----------------------------------------------*/
/*   Multi File Upload Tab Copy Buttons
/*----------------------------------------------*/

  $( '#public-multi-copy-btn' ).on("click", function() {

      "use strict";

       var clipboardText = "";
       clipboardText = $( '#public-link-value-multi' ).val();
       copyToClipboard( clipboardText );

       $(this).tooltip('hide')
        .attr('data-original-title', 'Copied')
        .tooltip('show');
     
  });


  $( '#private-multi-copy-btn' ).on("click", function() {

      "use strict";

       var clipboardText = "";
       clipboardText = $( '#private-link-value-multi' ).val();
       copyToClipboard( clipboardText );

       $(this).tooltip('hide')
        .attr('data-original-title', 'Copied')
        .tooltip('show');
     
  });

});



/*===========================================================================
*
*  09 - ENABLE TOOLTIPS
*
*============================================================================*/

$(document).ready(function() {

  "use strict";

/*----------------------------------------------*/
/*    Single File Upload Tab Button Tooltips
/*----------------------------------------------*/

	$('#public-copy-btn').tooltip();
	$('#private-copy-btn').tooltip();
  $('#public-download-btn').tooltip();
  $('#private-download-btn').tooltip();

/*----------------------------------------------*/
/*    Multi File Upload Tab Button Tooltips
/*----------------------------------------------*/

  $('#public-multi-copy-btn').tooltip();
  $('#private-multi-copy-btn').tooltip();
  $('#public-multi-download-btn').tooltip();
  $('#private-multi-download-btn').tooltip();

});



/*===========================================================================
*
*  10 - INPUT FIELD
*
*============================================================================*/


$(document).ready(function() {

  "use strict";

	$( '.input-file' ).each( function() {

		var $input	 = $( this ),
			$label	 = $input.next( 'label' ),
			labelVal = $label.html();

		$input.on( 'change', function( e ) {

			var fileName = '';

			if( this.files && this.files.length > 1 )
				fileName = ( this.getAttribute( 'data-multiple-caption' ) || '' ).replace( '{count}', this.files.length );
			else if( e.target.value )
				fileName = e.target.value.split( '\\' ).pop();

			if( fileName )
				$label.find( 'span' ).html( fileName );
			else
				$label.html( labelVal );

		});

		// Firefox bug fix
		$input
		.on( 'focus', function(){ $input.addClass( 'has-focus' ); })
		.on( 'blur', function(){ $input.removeClass( 'has-focus' ); });
	});
});



/*===========================================================================
*
*  11 - EMAIL SENDING BLOCK UNTIL FILE IS UPLOADED SUCCESSFULLY
*
*============================================================================*/

/*----------------------------------------------*/
/*    Single File Upload Email Sending
/*----------------------------------------------*/

$(document).ready(function() {

  var activeTab = 'single-file-tab';


  $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
    
      //show selected tab - active
      activeTab =  $(e.target).prop('id');
      
    
  });


  $('#enable-email').on("change", function() {

      "use strict";

    	if(this.checked) {

          if (activeTab == 'single-file-tab') {
    		
              if(($('#public-link-value').val() === '') && ($('#private-link-value').val() === '')) {

    			          var message = "Select and upload file before sending an email.";
    			
                    showEmailStatusMessage(message, 'error');

                    $('#form-name').prop("disabled", true);
                    $('#form-email').prop("disabled", true);
                    $('#form-content').prop("disabled", true);
                    $('#email-error-message').text('');
                    $('#google-recaptcha').addClass("is-hidden").slideUp();

                    return false;

              } else {

                    $('#email-status-message').slideUp();

                    $('#form-name').prop("disabled", false);
                    $('#form-email').prop("disabled", false);
                    $('#form-content').prop("disabled", false);
                    $('#google-recaptcha').slideDown();

              } 

	         } else if (activeTab == 'multi-file-tab') {

                if (($('#public-link-value-multi').val() === '') && ($('#private-link-value-multi').val() === '')) {


                      var message = "Select and upload file(s) before sending an email.";
            
                      showEmailStatusMessage(message, 'error');

                      $('#form-name').prop("disabled", true);
                      $('#form-email').prop("disabled", true);
                      $('#form-content').prop("disabled", true);
                      $('#email-error-message').text('');
                      $('#google-recaptcha').addClass("is-hidden").slideUp();

                      return false;

                } else {

                      $('#email-status-message').slideUp();

                      $('#form-name').prop("disabled", false);
                      $('#form-email').prop("disabled", false);
                      $('#form-content').prop("disabled", false);
                      $('#google-recaptcha').slideDown();
                } 

          } else {

                if (($('#public-link-value-multipart').val() === '') && ($('#private-link-value-multipart').val() === '')) {

                      var message = "Select and upload file before sending an email.";
            
                      showEmailStatusMessage(message, 'error');

                      $('#form-name').prop("disabled", true);
                      $('#form-email').prop("disabled", true);
                      $('#form-content').prop("disabled", true);
                      $('#email-error-message').text('');
                      $('#google-recaptcha').addClass("is-hidden").slideUp();

                      return false;

                } else {

                      $('#email-status-message').slideUp();
                      
                      $('#form-name').prop("disabled", false);
                      $('#form-email').prop("disabled", false);
                      $('#form-content').prop("disabled", false);
                      $('#google-recaptcha').slideDown();
                } 
          }

    	} else {

    		$('#form-name').prop("disabled", true);
    		$('#form-email').prop("disabled", true);
    		$('#form-content').prop("disabled", true);
    		$('#email-error-message').text('');
        $('#google-recaptcha').addClass("is-hidden").slideUp();
  
    	}

  });


  $('#email-submit').on("click", function() {

      $('#email-status-message').removeClass('is-hidden');

  });

});

function showEmailStatusMessage(message,status){
  
  "use strict";

  if (status == "success") {
      
      $("#email-status-message").addClass("success-message").removeClass("error-message");
      $("#email-status-message").css({"padding":"15px","text-align":"center","margin-bottom":"1.5rem"});
    
  } else if (status == "error") {
      
      $("#email-status-message").removeClass("success-message").addClass("error-message");
      $("#email-status-message").css({"padding":"15px","text-align":"center","margin-bottom":"1.5rem"});
  }

  $("#email-status-message")
    .slideDown()
    .html(message)
    .delay(2000)
    .slideUp();

}


/*--------------------------------------------------*/
/*    BLocking Submit Button until reCaptcha Passed
/*--------------------------------------------------*/

$(document).ready(function(){

    "use strict";

    $("#email-submit").prop("disabled", true).addClass("is-blocked");

});

function enableEmailButton() {

    "use strict";

    $("#email-submit").prop("disabled", false).removeClass("is-blocked");
    
}



/*===========================================================================
*
*  12 - PARTICULES.JS BACKGROUD SCRIPT
*
*============================================================================*/

$(document).ready(function() {

  "use strict";

  particlesJS('particles-js',
    
    {
      "particles": {
        "number": {
          "value": 80,
          "density": {
            "enable": true,
            "value_area": 600
          }
        },
        "color": {
          "value": "#BCBCBC"
        },
        "shape": {
          "type": "circle",
          "stroke": {
            "width": 0,
            "color": "#BCBCBC"
          },
          "polygon": {
            "nb_sides": 5
          },
          "image": {
            "src": "img/github.svg",
            "width": 100,
            "height": 100
          }
        },
        "opacity": {
          "value": 0.8,
          "random": false,
          "anim": {
            "enable": false,
            "speed": 1,
            "opacity_min": 0.1,
            "sync": false
          }
        },
        "size": {
          "value": 3,
          "random": true,
          "anim": {
            "enable": false,
            "speed": 40,
            "size_min": 0.1,
            "sync": false
          }
        },
        "line_linked": {
          "enable": true,
          "distance": 150,
          "color": "#BCBCBC",
          "opacity": 0.4,
          "width": 1
        },
        "move": {
          "enable": true,
          "speed": 4,
          "direction": "none",
          "random": false,
          "straight": false,
          "out_mode": "out",
          "attract": {
            "enable": false,
            "rotateX": 600,
            "rotateY": 1500
          }
        }
      },
      "interactivity": {
        "detect_on": "window",
        "events": {
          "onhover": {
            "enable": true,
            "mode": "repulse"
          },
          "onclick": {
            "enable": true,
            "mode": "push"
          },
          "resize": true
        },
        "modes": {
          "grab": {
            "distance": 400,
            "line_linked": {
              "opacity": 1
            }
          },
          "bubble": {
            "distance": 400,
            "size": 40,
            "duration": 2,
            "opacity": 8,
            "speed": 3
          },
          "repulse": {
            "distance": 100
          },
          "push": {
            "particles_nb": 4
          },
          "remove": {
            "particles_nb": 2
          }
        }
      },
      "retina_detect": true
      
    }
  );

});



/*===========================================================================
*
* 13 - UPLOAD PROGRESS BAR
*
*============================================================================*/

/*----------------------------------------------*/
/*    Single File Upload
/*----------------------------------------------*/

$(document).ready(function(){

  $("#single-upload-form").on("submit", function(event) {

      "use strict";            

      var e = $(this).attr("action"),
          a = new FormData(this);
          $(".progress-bar").css("width", 0 + "%").text('');

      return $.ajax({
          url: "single-file-upload.php",
          type: "post",
          data: a,
          contentType: false,
          processData: false,
          xhr: function() {
              var t = $.ajaxSettings.xhr();
              return t.upload && t.upload.addEventListener("progress", function(t) {
                  var e = 0,
                      a = t.loaded || t.position,
                      n = t.total;
                  t.lengthComputable && (e = Math.ceil(a / n * 100), $(".progress-bar").css("width", e + "%").text(e + " %"))
              }, !0), t
          }
      }).done(function(response) {



        // console.log(response['public-url']);
        // console.log(response['status']);


        
         
      })
  });


  /*----------------------------------------------*/
  /*    Multi File Upload 
  /*----------------------------------------------*/

  $("#multi-upload-form").on("submit", function(event) {

      "use strict";            

      var e = $(this).attr("action"),
          a = new FormData(this);

      return $.ajax({
          url: "multi-file-upload.php",
          type: "post",
          data: a,
          contentType: false,
          processData: false,
          xhr: function() {
              var t = $.ajaxSettings.xhr();
              return t.upload && t.upload.addEventListener("progress", function(t) {
                  var e = 0,
                      a = t.loaded || t.position,
                      n = t.total;
                  t.lengthComputable && (e = Math.ceil(a / n * 100), $("#multi-progress-bar").css("width", e + "%").text(e + " %"))
              }, !0), t
          }
      }).done(function(event) {

        console.log(event);
        console.log('done');
         
      })
  });


  /*----------------------------------------------*/
  /*    Multi-Part File Upload 
  /*----------------------------------------------*/

  $("#multi-part-upload-form").on("submit", function(event) {

      "use strict";            

      var e = $(this).attr("action"),
          a = new FormData(this);

      return $.ajax({
          url: "multi-part-file-upload.php",
          type: "post",
          data: a,
          contentType: false,
          processData: false,
          xhr: function() {
              var t = $.ajaxSettings.xhr();
              return t.upload && t.upload.addEventListener("progress", function(t) {
                  var e = 0,
                      a = t.loaded || t.position,
                      n = t.total;
                  t.lengthComputable && (e = Math.ceil(a / n * 100), $("#progress-bar-multipart").css("width", e + "%").text(e + " %"))
              }, !0), t
          }
      }).done(function(event) {

        console.log(event);
        console.log('done');
         
      })
  });

});




/*===========================================================================
*
*  14 - FILE DOWNLOAD BUTTONS
*
*============================================================================*/

$(document).ready(function(){


/*----------------------------------------------*/
/*    Single File Link Download Buttons
/*----------------------------------------------*/

  $("#public-download-btn").on("click", function() {

    "use strict";

    $("<a />", {
   
        download: $.now() + ".txt",
        // set `href` to `objectURL` of `Blob` of `textarea` value
        href: URL.createObjectURL(
          new Blob([$("#public-link-value").val()], {
            type: "text/plain"
          }))
      }).appendTo("body")[0].click();

      // remove appended `a` element after "Save File" dialog,
      // `window` regains `focus` 
      $(window).on("focus", function() {
        $("a").last().remove()
      });

      $(this).tooltip('hide')
        .attr('data-original-title', 'Downloading')
        .tooltip('show');

  });


  $("#private-download-btn").on("click", function() {

    "use strict";

    $("<a />", {
   
        download: $.now() + ".txt",
        // set `href` to `objectURL` of `Blob` of `textarea` value
        href: URL.createObjectURL(
          new Blob([$("#private-link-value").val()], {
            type: "text/plain"
          }))
      }).appendTo("body")[0].click();

      // remove appended `a` element after "Save File" dialog,
      // `window` regains `focus` 
      $(window).on("focus", function() {
        $("a").last().remove()
      });

      $(this).tooltip('hide')
        .attr('data-original-title', 'Downloading')
        .tooltip('show');

  });


/*----------------------------------------------*/
/*    Multi File Link Download Buttons
/*----------------------------------------------*/

  $("#public-multi-download-btn").on("click", function() {

    "use strict";

    $("<a />", {
   
        download: $.now() + ".txt",
        // set `href` to `objectURL` of `Blob` of `textarea` value
        href: URL.createObjectURL(
          new Blob([$("#public-link-value-multi").val()], {
            type: "text/plain"
          }))
      }).appendTo("body")[0].click();

      // remove appended `a` element after "Save File" dialog,
      // `window` regains `focus` 
      $(window).on("focus", function() {
        $("a").last().remove()
      });

      $(this).tooltip('hide')
        .attr('data-original-title', 'Downloading')
        .tooltip('show');

  });


  $("#private-multi-download-btn").on("click", function() {

    "use strict";

    $("<a />", {
   
        download: $.now() + ".txt",
        // set `href` to `objectURL` of `Blob` of `textarea` value
        href: URL.createObjectURL(
          new Blob([$("#private-link-value-multi").val()], {
            type: "text/plain"
          }))
      }).appendTo("body")[0].click();

      // remove appended `a` element after "Save File" dialog,
      // `window` regains `focus` 
      $(window).on("focus", function() {
        $("a").last().remove()
      });

      $(this).tooltip('hide')
        .attr('data-original-title', 'Downloading')
        .tooltip('show');

  });


});



/*===========================================================================
*
*  15 - ACTIVE TAB PANE
*
*============================================================================*/

$(document).ready(function(){

    "use strict";

    $('a[data-toggle="tab"]').on('show.bs.tab', function(e) {

        localStorage.setItem('activeTab', $(e.target).attr('href'));
    
    });

    var activeTab = localStorage.getItem('activeTab');

    if(activeTab){
        $('#upload-tabs a[href="' + activeTab + '"]').tab('show');
    }

});





 