<?php 

/*
 * Copyright (c) 2019 Berkine Design
 * ================================================================
 * 
 *
 * Main PHP File to send multiple files to Amazon S3 bucket at once
 * 
 * 
 * ================================================================
 * Original Filename: multi-file-upload.php
 * Last Modified Date: Mon, 25 Nov 2019
 *
 */

	# Include AWS S3 credentials and parameters
	require 'configs/start.php';
	require_once 'init.php';

	use Aws\S3\S3Client; 
	use Aws\CommandPool;  
	use AWS\CommandInterface;
	use AWS\ResultInterface;  
	use GuzzleHttp\Promise\PromiseInterface;
	use Aws\Exception\AwsException;
	use Aws\Exception\CredentialsException;
	use Guzzle\Service\Exception\CommandTransferException;


	# Multi File Upload Variables
	$public_url = '';						# Public files link
	$private_url = '';						# Private files link
	$private_url_duration = '';				# Private files link duration (valid only for set time)
	

	# Response for AJAX Request
	$response_array = [];
	$response_array_private = [];

	# Maximum allowed file size to upload - can be changed as needed (make sure PHP ini file is updated accordingly)
	# Multiple File Upload size limit is set as 10 MB in Bytes
	$file_size_limit = 10485760; 

	
	#=============================================================================================
	#
	# UPLOAD MULTIPLE FILES to Amazon S3 bucket and generating public/private links
	#
	#=============================================================================================

	# Check if Multi File is selected for File Upload
	if(isset($_FILES['multi-file'])) {

 
        $files = $_FILES['multi-file'];
        $toBucket = $config['s3']['bucketName'];


        try {

		       
	        # This generator accepts the iterator that yields files and the name of the bucket to upload the files to
	        $commandGenerator = function($files, $bucket) use ($s3) {

	        	$files_number = count($files["name"]);

	        	for ($i = 0; $i < $files_number; $i++) {                 
	                    

	        		$file_name = $files['name'][$i];	
	        		$file_tmp = $files['tmp_name'][$i];


	        		# Yield a command that is executed by the pool
	        		yield $s3 -> getCommand('PutObject', [
	        			'Bucket' => $bucket, 									# Bucket Name
	        			'Key' => "codecanyon-s3/{$file_name}", 					# S3 Object Name
	        			'SourceFile' => $file_tmp,								# S3 Object Content
	        			'ServerSideEncryption' => 'AES256',						# Server Side Encryption (optional)
						'StorageClass' => 'STANDARD',  				# S3 Storage Type - Can be one of the follwoing: STANDARD|REDUCED_REDUNDANCY|GLACIER|STANDARD_IA|ONEZONE_IA|INTELLIGENT_TIERING|DEEP_ARCHIVE 
						'ACL' => 'public-read', 								# S3 Object Access Control List - Can be one of the following: private|public-read|public-read-write|authenticated-read|aws-exec-read|bucket-owner-read|bucket-owner-full-control
						'ContentDisposition' => 'attachment'		# Allows you to download the file without opening it in the browser 
	        		]);
	        	}
	        };



	        # Get the Links for uploaded files (Public Links)
	        function show_results_public($status_code, $result, $file_name) {
    			
    			global $public_url;

	    		# If successfully uploaded to S3 Bucket
				if ($status_code === 200) {

					# Public URL of the Upload S3 object
					$public_url .= "File - " . $file_name . " - link:\n" . "*************************************\n" . $result . "\n\n";
			
				}

			}



			# Get the Links for uploaded files (Public Links)
	        function show_results_private($status_code, $file_name) {
    			
    			global $private_url;
    			global $private_url_duration;
    			global $s3;
    			global $toBucket;

	    		# If successfully uploaded to S3 Bucket
				if ($status_code === 200) {
					

					# Return uploaded S3 object
					$s3_object = $s3 -> getCommand('GetObject',[
						'Bucket' => $toBucket,
						'Key' => "codecanyon-s3/{$file_name}"
					]);
					

					# Create S3 Object Presigned Private URL with expiration time
					$request = $s3->createPresignedRequest($s3_object , strtotime($_POST['timer-multi'] . ' minutes'));

					# Return URL of the S3 Object with Presigned Private URL
					$presigned_url = (string)$request->getUri();
					$private_url .= "File - ". $file_name ." - link:\n" . "*************************************\n" . $presigned_url . "\n\n";

					
					# Time notification until which private link is valid
					$time = date('Y-m-d H:i:s', strtotime($_POST['timer-multi'] . ' minute'));
					

					# Time notification message for the user
					$private_url_duration = "*Private link valid for " . $_POST['timer-multi'] . " minutes until " . $time . " GMT+1";
			
				}

			}



		    # If "PUBLIC LINK" radio button was selected:
			# ===========================================
			if ($_POST['radiobuttonmulti'] === 'public-link') {	


		        # Create the generator using the files iterator
		        $commands = $commandGenerator($files, $toBucket);

		        
		        # Create a pool and provide an optional array of configuration
				$pool = new CommandPool($s3, $commands, [
		    	
		    		# Only send 3 files at a time (this is set to 25 by default)
		    		'concurrency' => 3,
		    		
		    		# Invoke this function before executing each command
		    		'before' => function (CommandInterface $cmd, $iterKey) { },
		    
		    		# Invoke this function for each successful transfer
		    		'fulfilled' => function (
		        		ResultInterface $result,
		        		$iterKey,
		        		PromiseInterface $aggregatePromise
		    		) {

		        		# Status of the S3 upload (returns 200 if uploaded successfully)
	 					$status_code = $result['@metadata']['statusCode'];
	 					$result = $result['@metadata']['effectiveUri'];
	 					
	 					$temp_name = explode('/codecanyon-s3/', $result);
						$file_name = strtolower(end($temp_name));

	 					show_results_public($status_code, $result, $file_name);
		    		
		    		},
		    
		    		# Invoke this function for each failed transfer    		
		    		'rejected' => function (AwsException $reason, $iterKey, PromiseInterface $aggregatePromise ) { },

				]);

			
				# Initiate the pool transfers
				$promise = $pool->promise();

				# Force the pool to complete synchronously
				$promise->wait();


				$_SESSION['file-link'] = $public_url;


				# Send back the Results
				$response_array['public-url'] = $public_url;
				$response_array['message'] = 'File(s) Successfully Uploaded.';
				$response_array['status'] = 'success';
				
				header('Content-type: application/json');
				echo json_encode($response_array, JSON_UNESCAPED_SLASHES);


			
			  # If "PRIVATE LINK" radio button was selected:
			  # ============================================
			} elseif($_POST['radiobuttonmulti'] === 'private-link') {


				# Create the generator using the files iterator
		        $commands = $commandGenerator($files, $toBucket);


		        # Create a pool and provide an optional array of configuration
				$pool = new CommandPool($s3, $commands, [
		    	
		    		# Only send 3 files at a time (this is set to 25 by default)
		    		'concurrency' => 3,
		    		
		    		# Invoke this function before executing each command
		    		'before' => function (CommandInterface $cmd, $iterKey) { },
		    
		    		# Invoke this function for each successful transfer
		    		'fulfilled' => function (
		        		ResultInterface $result,
		        		$iterKey,
		        		PromiseInterface $aggregatePromise
		    		) {

		        		# Status of the S3 upload (returns 200 if uploaded successfully)
	 					$status_code = $result['@metadata']['statusCode'];
	 					$result = $result['@metadata']['effectiveUri'];

	 					$temp_name = explode('/codecanyon-s3/', $result);
						$file_name = strtolower(end($temp_name));

	 					show_results_private($status_code, $file_name);
		    		
		    		},
		    
		    		# Invoke this function for each failed transfer    		
		    		'rejected' => function ( AwsException $reason, $iterKey, PromiseInterface $aggregatePromise ) {	},

				]);

				# Initiate the pool transfers
				$promise = $pool->promise();

				# Force the pool to complete synchronously
				$promise->wait();


				$_SESSION['file-link'] = $private_url;
				$_SESSION['url-time'] = $private_url_duration;


				# Send back the Results
				$response_array_private['private-url'] = $private_url;
				$response_array_private['private-url-duration'] = $private_url_duration;
				$response_array_private['message'] = 'File(s) Successfully Uploaded.';
				$response_array_private['status'] = 'success';
				
				header('Content-type: application/json');
				echo json_encode($response_array_private, JSON_UNESCAPED_SLASHES);

			}


		} catch (S3Exception $e) {

    		$response_array['message'] = 'There was an error: ' + $e->getMessage();
			$response_array['status'] = 'error';
			
			header('Content-type: application/json');
			echo json_encode($response_array, JSON_UNESCAPED_SLASHES);

    	} catch (InvalidArgumentException $e) {

	 		$response_array['message'] = 'There was an error: ' + $e->getMessage();
			$response_array['status'] = 'error';
			
			header('Content-type: application/json');
			echo json_encode($response_array, JSON_UNESCAPED_SLASHES);

		} catch (CredentialsException $e) {

			$response_array['message'] = 'There was an error: ' + $e->getMessage();
			$response_array['status'] = 'error';
			
			header('Content-type: application/json');
			echo json_encode($response_array, JSON_UNESCAPED_SLASHES);
		}

		
	}



 ?>