<?php
	
	/*
	 *
	 * Author: Berkine Design
	 * Project: Amazon S3 File Uploaded
	 * ==================================
	 * Copyright (c) 2019 Berkine Design
	 * ==================================
	 *
	 */
	

	# Start session
	if (session_status() == PHP_SESSION_NONE) {
	
		require_once 'init.php';
	
	}

	# Include main PHP file
	require_once 'single-file-upload.php';
	require_once 'multi-file-upload.php';
	require_once 'multi-part-file-upload.php';
	require_once 'send-email.php';

?>


<!DOCTYPE html>
<html lang="en">
<head>


	<!-- GENERAL METAS -->
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">


	<!-- WEBSITE TITLE -->
	<title>AWS S3 File Uploader</title>


	<!-- INCLUDE CSS FILES -->
	<link rel="stylesheet" href="distr/css/bootstrap.min.css">
	<link rel="stylesheet" href="distr/css/bootstrap-slider.min.css">	
	<link rel="stylesheet" href="distr/css/all.min.css">
	<link rel="stylesheet" href="distr/css/styles.css">

	
	<!-- INCLUDE FONTS -->
	<link href="https://fonts.googleapis.com/css?family=Poppins:400,600,700,800" rel="stylesheet">
	<link href='https://fonts.googleapis.com/css?family=Lato:300,400,700,900' rel='stylesheet' type='text/css'>
	
	
	<!-- JS FILES FOR PRELOAD CHECK-->
	<script src="distr/js/jquery-3.4.1.min.js"></script>
	<script src="distr/js/modernizr.js"></script>
	

	<!-- PRELOAD CHECK -->
	<script>
		$(window).on("load", function() {

			$(".se-pre-con").fadeOut("slow");
			
		});
	</script>

	
</head>
<body>
	
	<!-- PRELOAD CHECK -->
	<div class="se-pre-con"></div>

	<!-- MAIN SECTION -->
	<section>
		
		<!-- BACKGROUND PARTICLES EFFECT -->
		<div id="particles-js">

			<div class="container-fluid">

				<div class="container">

					

					<!-- SECTION TITLE -->
					<div class="text-center">
			
						<div class="form-title">
							<h3><span>Amazon S3</span> File Uploader</h3>
						</div>

					</div> <!-- END SECTION TITLE -->



					<!-- S3 BUCKET UPLOADER -->
					<div class="row no-gutters">

						<div class="form-wrapper" >


							
							<!-- INTRUCTIONS -->
							<div class="text-center">					
								
								<div id="instructions">

									<h6><i class="fas fa-info-circle"></i><span>Instructions</span> for the demo:</h6>
									
									<ul>
										<li>File size limit - Single File Upload: <span>5MB</span>; Multi File Upload: <span>10MB</span>; Multi-Part Upload: <span>20MB;</span></li>
										<li>Multi file upload quantity - up to <span>3 Files</span> are allowed to be uploaded simultaneously.</li>
										<li>File type restrictions - Files with following extentions are not allowed for the demo: <span>'exe', 'msi', 'bat', 'cmd', 'reg', 'jar'.</span></li>
										<li>File availability limit - All uploaded files will be automatically deleted from S3 Bucket after 1 hour.</li>
										<li><span>Private Signed S3 Link</span> - Download link will be available only for the specified timeframe (by default for 5 minutes).</li>
										<li>Security - All files are uploaded with <span>AES-256 Server Side Encyption</span> enabled option.</li>
									</ul>
			
								</div>								

							</div> <!-- END INTRUCTIONS -->
							



							<!-- MAIN FORM TO UPLOAD FILES -->
							<ul class="nav nav-tabs" role="tablist" id="upload-tabs">
								
								<!-- SINGLE FILE -->
							  	<li class="nav-item">
							    	<a class="nav-link active" id="single-file-tab" data-toggle="tab" href="#single-file" role="tab" aria-controls="single-file"
							      aria-selected="true">Single File Upload</a>
							  	</li>
								
								<!-- MULTI FILE -->
							  	<li class="nav-item">
							    	<a class="nav-link" id="multi-file-tab" data-toggle="tab" href="#multi-file" role="tab" aria-controls="multi-file"
							      aria-selected="false">Multi File Upload</a>
							  	</li>
								
								<!-- MULTI-PART FILE -->
							  	<li class="nav-item">
							    	<a class="nav-link" id="multi-part-tab" data-toggle="tab" href="#multi-part" role="tab" aria-controls="multi-part"
							      aria-selected="false">Multi-Part Upload</a>
							  	</li>					

							</ul> <!-- END MAIN FORM TO UPLOAD FILES -->

							

	
							<!-- TAB CONTENTS -->
							<div class="tab-content">


						   		<!-- =====================================================

								 		SINGLE UPLOAD FORM TAB 

								==========================================================-->
								<div class="tab-pane show active" id="single-file" role="tabpanel" aria-labelledby="single-file">
									

									<!-- SINGLE FORM TO UPLOAD FILES -->
									<form id="single-upload-form" action="single-file-upload.php" method="post" enctype="multipart/form-data">
									

										<div class="row tab-box no-gutters">


											<!-- SELECT FILE AND STATUS BAR -->
											<!-- ========================== -->
											<div class="col-md-6 file-uploader-box">
												

												<!-- SELECT FILE -->
												<div class="select-file">
													<input type="file" name="single-file" id="file-single" class="input-file"  required />
													<label for="file-single">
														<i class="fas fa-cloud-upload-alt"></i>
														<span id="file-upload-label">Choose a file...</span>
													</label>		
												</div>
												

												<!-- UPLOAD PROGRESS BAR -->
												<div class="form-progress-bar">
													<div class="progress active">
														<div class="progress-bar progress-bar-animated progress-bar-striped" role="progressbar" style="width:0%" id="progress-bar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
													</div>
												</div>
												

												<!-- STATUS MESSAGES -->
												<div id="single-upload-status-message">
													<span></span>					
												</div>
												

												<!-- UPLOAD BUTTON -->
												<div class="form-submit-button">
													<button class="btn upload" type="submit" id="upload-submit" name="upload-submit">Upload File</button>	
												</div>

											</div> <!-- END SELECT FILE AND STATUS BAR -->
											

											
											<!-- DOWNLOAD LINKS 		    -->
											<!-- ========================== -->
											<div class="col-md-6">
												

												<!-- PUBLIC LINK -->
												<div class="public-link">									

													<!-- RADIO BUTTON -->
													<div class="radio-control">
														<input class="input-control" type="radio" name="radiobutton" id="radio-button-public" value="public-link" checked>
														<label class="label-control" for="radio-button-public">
										    				Public S3 File Link
														</label>
													</div>
													
												
													
													<!-- LINK URL -->
													<div class="input-group">
														<input class="form-control" id="public-link-value" type="text" readonly placeholder="Share your public URL...">

														<div class="input-group-append">

															<!-- COPY & DOWNLOAD BUTTONS -->
			    											<button class="btn btn-outline-secondary" id="public-copy-btn" type="button" data-toggle="tooltip" data-placement="top" title="Copy to Clipboard"><i class="fas fa-copy"></i></button>
			    											<button class="btn btn-outline-secondary" id="public-download-btn" type="button" data-toggle="tooltip" data-placement="top" title="Download Link"><i class="fas fa-download"></i></button>

			  											</div>
													</div>
												
												</div> <!-- END PUBLIC LINK -->

												

												<!-- PRIVATE LINK -->
												<div class="private-link">
													
													<!-- RADIO BUTTON -->
													<div class="radio-control">
														<input class="input-control" type="radio" name="radiobutton" id="radio-button-private" value="private-link">
														<label class="label-control" for="radio-button-private">
										    				Private Signed S3 File Link 
														</label>
													</div>
													

													<!-- LINK URL -->												
													<div class="input-group">

														<input class="form-control" type="text" id="private-link-value" readonly placeholder="Share your private URL...">

														<div class="input-group-append">

															<!-- COPY & DOWNLOAD BUTTONS -->
			    											<button class="btn btn-outline-secondary" id="private-copy-btn" type="button" data-toggle="tooltip" data-placement="top" title="Copy to Clipboard"><i class="fas fa-copy"></i></button>
			    											<button class="btn btn-outline-secondary" id="private-download-btn" type="button" data-toggle="tooltip" data-placement="top" title="Download Link"><i class="fas fa-download"></i></button>

			  											</div>  											
													</div>


													<!-- MODIFY LINK TIME -->										
													<div id="link-time">
														<div class="slider-primary slider-strips">

															<div class="custom-control custom-checkbox">

			  													<input type="checkbox" class="custom-control-input" id="ex7-enabled">
			  													<label class="custom-control-label" for="ex7-enabled">Modify Link Time</label>
																
																<div id="splitter">
																	<span id="counter-left">1 min</span>
																		<input id="ex7" type="range" data-slider-min="1" data-slider-max="20" data-slider-step="1" data-slider-value="5" data-slider-enabled="false" name="timer"/>
																	<span>20 min</span>	
																</div>

															</div>

														</div>
													</div>
													

													<!-- COUNTDOWN FOR THE SIGNED LINK -->	
													<p id="private-link-duration"></p>					


												</div> <!-- END LIMITED DIRECT S3 PRIVATE LINK -->			
												
												
											</div> <!-- END UPLOAD LINKS -->


										</div> <!-- END ROW -->


									</form> <!-- SINGLE FORM TO UPLOAD FILES -->

								
								</div> <!-- END SINGLE UPLOAD FORM TAB -->



								
								<!-- ========================================================

								 		MULTI UPLOAD FORM TAB 

								 ==========================================================-->
								<div class="tab-pane" id="multi-file" role="tabpanel" aria-labelledby="multi-file">
									

									<!-- MULTI FORM TO UPLOAD FILES -->
									<form id="multi-upload-form" action="multi-file-upload.php" method="post" enctype="multipart/form-data">

										<div class="row tab-box no-gutters">

											
											<!-- SELECT FILES AND STATUS BAR -->
											<div class="col-md-6 file-uploader-box">
												

												<!-- SELECT FILES -->
												<div class="select-file">
													<input type="file" name="multi-file[]" id="file-multi" class="input-file" data-multiple-caption="{count} files selected" multiple />
													<label for="file-multi">
														<i class="fas fa-cloud-upload-alt"></i>
														<span id="file-upload-label-multi">Choose multiple files...</span>
													</label>		
												</div>
												

												<!-- UPLOAD PROGRESS BAR -->
												<div class="form-progress-bar">
													<div class="progress active">
														<div class="progress-bar progress-bar-animated progress-bar-striped" role="progressbar" style="width:0%" id="multi-progress-bar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
													</div>
												</div>
												

												<!-- STATUS MESSAGES -->
												<div id="multi-upload-status-message"></div>
												

												<!-- UPLOAD BUTTON -->
												<div class="form-submit-button">
													<button class="btn upload" type="submit" id="multi-upload-submit" name="multi-upload-submit">Upload Files</button>	
												</div>

											</div> <!-- END SELECT FILES AND STATUS BAR -->


											
											<!-- DOWNLOAD LINKS 		    -->
											<!-- ========================== -->
											<div class="col-md-6">

												
												<!-- PUBLIC LINK -->
												<div class="public-link">
													
													<!-- RADIO BUTTON -->
													<div class="radio-control">
														<input class="input-control" type="radio" name="radiobuttonmulti" id="radio-button-public-multi" value="public-link" checked>
														<label class="label-control" for="radio-button-public-multi">
										    				Public S3 File Links
														</label>
													</div>
													
													
													<!-- LINKS URLs -->
													<div class="input-group">

														<textarea class="form-control" id="public-link-value-multi" rows="4" readonly placeholder="All public URLs will be available here..."></textarea>

														<div class="input-group-append">
															
															<!-- COPY & DOWNLOAD BUTTONS -->
			    											<button class="btn btn-outline-secondary" id="public-multi-copy-btn" type="button" data-toggle="tooltip" data-placement="top" title="Copy to Clipboard"><i class="fas fa-copy"></i></button>
			    											<button class="btn btn-outline-secondary" id="public-multi-download-btn" type="button" data-toggle="tooltip" data-placement="top" title="Download Links"><i class="fas fa-download"></i></button>

			  											</div>
													</div>
												
												</div> <!-- END PUBLIC LINKS -->


												
												<!-- PRIVATE LINKS -->
												<div class="private-link">
													
													<!-- RADIO BUTTON -->
													<div class="radio-control">
														<input class="input-control" type="radio" name="radiobuttonmulti" id="radio-button-private-multi" value="private-link">
														<label class="label-control" for="radio-button-private-multi">
										    				Private Signed S3 File Links
														</label>
													</div>


													<!-- LINK URL -->			
													<div class="input-group">
														<textarea class="form-control" id="private-link-value-multi" rows="4" readonly placeholder="All private URLs will be available here..."></textarea>							
														<div class="input-group-append">
															
															<!-- COPY & DOWNLOAD BUTTONS -->
			    											<button class="btn btn-outline-secondary" id="private-multi-copy-btn" type="button" data-toggle="tooltip" data-placement="top" title="Copy to Clipboard"><i class="fas fa-copy"></i></button>
			    											<button class="btn btn-outline-secondary" id="private-multi-download-btn" type="button" data-toggle="tooltip" data-placement="top" title="Donwload Links"><i class="fas fa-download"></i></button>

			  											</div>  											
													</div>


													<!-- MODIFY LINK TIME -->				
													<div id="link-time">
														<div class="slider-primary slider-strips">

															<div class="custom-control custom-checkbox">

			  													<input type="checkbox" class="custom-control-input" id="ex8-enabled">
			  													<label class="custom-control-label" for="ex8-enabled">Modify Link Time</label>
																
																<div id="splitter">
																<span id="counter-left">1 min</span>
																	<input id="ex8" type="range" data-slider-min="1" data-slider-max="20" data-slider-step="1" data-slider-value="5" data-slider-enabled="false" name="timer-multi"/>
																<span>20 min</span>	
																</div>

															</div>

														</div>
													</div>
													

													<!-- COUNTDOWN FOR THE LINK -->	
													<p id="private-link-duration-multi"></p>	
													

												</div> <!-- END LIMITED DIRECT S3 PRIVATE LINK -->			
												
												
											</div> <!-- END UPLOAD LINKS -->


										</div> <!-- END ROW -->
										
								
									</form> <!-- MULTI FORM TO UPLOAD FILES -->


								</div> <!-- END MULTI UPLOAD FORM TAB -->




								<!-- =====================================================

								 		MULTI-PART UPLOAD FORM TAB 

								==========================================================-->
								<div class="tab-pane" id="multi-part" role="tabpanel" aria-labelledby="multi-part">
									

									<!-- SINGLE FORM TO UPLOAD FILES -->
									<form id="multi-part-upload-form" action="multi-part-file-upload.php" method="post" enctype="multipart/form-data">
									

										<div class="row tab-box no-gutters">


											<!-- SELECT FILE AND STATUS BAR -->
											<!-- ========================== -->
											<div class="col-md-6 file-uploader-box">
												

												<!-- SELECT FILE -->
												<div class="select-file">
													<input type="file" name="multipart-file" id="multipart-file" class="input-file"  required />
													<label for="multipart-file">
														<i class="fas fa-cloud-upload-alt"></i>
														<span id="file-upload-label-multipart">Choose a file...</span>
													</label>		
												</div>
												

												<!-- UPLOAD PROGRESS BAR -->
												<div class="form-progress-bar">
													<div class="progress active">
														<div class="progress-bar progress-bar-animated progress-bar-striped" role="progressbar" style="width:0%" id="progress-bar-multipart" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
													</div>
												</div>
												

												<!-- STATUS MESSAGES -->
												<div id="multipart-upload-status-message">
													<span></span>					
												</div>
												

												<!-- UPLOAD BUTTON -->
												<div class="form-submit-button">
													<button class="btn upload" type="submit" id="upload-submit-multipart" name="upload-submit-multipart">Upload File</button>	
												</div>

											</div> <!-- END SELECT FILE AND STATUS BAR -->
											

											
											<!-- DOWNLOAD LINKS 		    -->
											<!-- ========================== -->
											<div class="col-md-6">
												

												<!-- PUBLIC LINK -->
												<div class="public-link">									

													<!-- RADIO BUTTON -->
													<div class="radio-control">
														<input class="input-control" type="radio" name="radiobutton-multipart" id="radio-button-public-multipart" value="public-link" checked>
														<label class="label-control" for="radio-button-public-multipart">
										    				Public S3 File Link
														</label>
													</div>
													
												
													
													<!-- LINK URL -->
													<div class="input-group">
														<input class="form-control" id="public-link-value-multipart" type="text" readonly placeholder="Share your public URL...">

														<div class="input-group-append">

															<!-- COPY & DOWNLOAD BUTTONS -->
			    											<button class="btn btn-outline-secondary" id="public-copy-btn" type="button" data-toggle="tooltip" data-placement="top" title="Copy to Clipboard"><i class="fas fa-copy"></i></button>
			    											<button class="btn btn-outline-secondary" id="public-download-btn" type="button" data-toggle="tooltip" data-placement="top" title="Download Link"><i class="fas fa-download"></i></button>

			  											</div>
													</div>
												
												</div> <!-- END PUBLIC LINK -->

												

												<!-- PRIVATE LINK -->
												<div class="private-link">
													
													<!-- RADIO BUTTON -->
													<div class="radio-control">
														<input class="input-control" type="radio" name="radiobutton-multipart" id="radio-button-private-multipart" value="private-link">
														<label class="label-control" for="radio-button-private">
										    				Private Signed S3 File Link 
														</label>
													</div>
													

													<!-- LINK URL -->												
													<div class="input-group">

														<input class="form-control" type="text" id="private-link-value-multipart" readonly placeholder="Share your private URL...">

														<div class="input-group-append">

															<!-- COPY & DOWNLOAD BUTTONS -->
			    											<button class="btn btn-outline-secondary" id="private-copy-btn" type="button" data-toggle="tooltip" data-placement="top" title="Copy to Clipboard"><i class="fas fa-copy"></i></button>
			    											<button class="btn btn-outline-secondary" id="private-download-btn" type="button" data-toggle="tooltip" data-placement="top" title="Download Link"><i class="fas fa-download"></i></button>

			  											</div>  											
													</div>


													<!-- MODIFY LINK TIME -->										
													<div id="link-time">
														<div class="slider-primary slider-strips">

															<div class="custom-control custom-checkbox">

			  													<input type="checkbox" class="custom-control-input" id="ex9-enabled">
			  													<label class="custom-control-label" for="ex9-enabled">Modify Link Time</label>
																
																<div id="splitter">
																	<span id="counter-left">1 min</span>
																		<input id="ex9" type="range" data-slider-min="1" data-slider-max="20" data-slider-step="1" data-slider-value="5" data-slider-enabled="false" name="timer-multipart"/>
																	<span>20 min</span>	
																</div>

															</div>

														</div>
													</div>
													

													<!-- COUNTDOWN FOR THE SIGNED LINK -->	
													<p id="private-link-duration-multipart"></p>					
													

												</div> <!-- END LIMITED DIRECT S3 PRIVATE LINK -->			
												
												
											</div> <!-- END UPLOAD LINKS -->


										</div> <!-- END ROW -->


									</form> <!-- MULTI PART FORM TO UPLOAD FILES -->

								
								</div> <!-- END MULTI PART UPLOAD FORM TAB -->



							</div> <!-- END TAB CONTENTS -->




							<!-- FORM TO SEND EMAILS  
							 ---=========================================-->
							<form id="send-email-form" action="" method="post" enctype="multipart/form-data">


								<div class="row" id="email-box-wrapper">

									
									<div class="col-sm-12 col-md-6">

										
										<!-- EMAIL FIELDS WRAPPER -->
										<div id="email-box">

											<div class="form-title">
												<h3>Forward <span> Link via Email</span></h3>
											</div>										
											

											<!-- ENABLE EMAIL SENDING CHECKBOX -->
											<div class="custom-control custom-checkbox">
	  											<input type="checkbox" class="custom-control-input" id="enable-email" name="enable-email">
	  											<label class="custom-control-label" for="enable-email">Share the link via Email</label>
											</div>
											

											<!-- EMAIL STATUS MESSAGES -->
											<div id="email-status-message">
												<p class="<?php echo htmlspecialchars($message_box_success, ENT_COMPAT, 'UTF-8'); ?>" id="email-success"><?php echo htmlspecialchars($email_success, ENT_COMPAT, 'UTF-8'); ?></p>
												<p class="<?php echo htmlspecialchars($message_box, ENT_COMPAT, 'UTF-8'); ?>" id="email-error"><?php echo htmlspecialchars($email_error, ENT_COMPAT, 'UTF-8'); ?></p>
											</div>
											

											<!-- NAME (NOT REQUIRED) -->
											<div class="form-group">
	    										<label for="form-name">Name <span class="small">(optional)</span></label>
											    <input type="text" class="form-control" id="form-name" name="form-name" placeholder="Receiver's Name" disabled="disabled">
											 </div>
											

											<!-- EMAIL ADDRESS (REQUIRED) -->
											<div class="form-group">
											    <label for="form-email">Email Address <span class="small">(required)</span></label>
											    <input type="email" class="form-control" id="form-email" name="form-email" aria-describedby="emailHelp" placeholder="Receiver's Email Address" disabled="disabled" required>
											    <small id="emailHelp" class="form-text text-muted">(Email addresses are not stored on our servers)</small>
											 </div>
											

											<!-- EMAIL CONTENT (OPTIONAL) -->
											 <div class="form-group">
											    <label for="form-content">Email Message <span class="small">(optional)</span></label>
											    <textarea class="form-control" id="form-content" rows="6" name="form-content" disabled="disabled" placeholder="Download links will be added automatically to email message"></textarea>
											 </div>													

											<!-- Google reCaptcha Verification -->
											<!-- INCLUDE YOUR reCAPTCHA PUBLIC SITEKEY HERE -->
											<div class="g-recaptcha is-hidden" id="google-recaptcha" data-sitekey="XXXXXXXXXXXXXXXXXXXXXXXXXXXXX" data-callback="enableEmailButton"></div>


											<!-- SEND EMAIL BUTTON -->
											 <input type="submit" class="email-send-btn" name="email-submit" id="email-submit" value="Send Email" disabled="disabled">

										</div> <!-- END EMAIL FIELDS WRAPPER -->

									</div>


									<div class="col-sm-12 col-md-6 d-flex align-items-end flex-column">	
											
										<div id="purchase-button" class="mt-auto">
											<p>Start uploading Now!</p>
											<a href="">Purchase S3 Uploader Now</a>
												
										</div>

									</div>

								</div> <!-- END ROW -->


							</form> <!-- END FORM TO SEND EMAILS -->

							
							<div id="logo">
								<p>Powered By</p>
								<img src="distr/img/aws.png" alt="AWS Logo">
							</div>


						</div> <!-- END FORM-WRAPPER CLASS -->


					</div> <!-- END S3 BUCKET UPLOADER -->
		


					<!-- BOTTOM COPYRIRGHT INFO -->
					<div id="copyright">		

						<p>Copyright &copy; 2019 Berkine Design <span>|</span> All Rights Reserved</p>
						<p>Amazon S3 is a service that belongs only to Amazon Web Services</p>

					</div>



				</div> <!-- END CONTAINER -->
			

			</div> <!-- END CONTAINER FLUID -->


		</div> <!-- END BACKGROUND PARTICLES EFFECT -->
		

	</section> <!-- END SECTION -->


	
	<!-- INCLUDED JS FILES -->
	<script src="distr/js/popper.min.js"></script>
	<script src="distr/js/bootstrap.min.js"></script>
	<script src="distr/js/bootstrap-slider.min.js"></script>
	<script src="distr/js/particles.min.js"></script>
	<script src="distr/js/clipboard.min.js"></script>
	<script src="distr/js/custom.js"></script>
	
	

</body>
</html>