<?php 

/*
 * Copyright (c) 2019 Berkine Design
 * ===================================================
 * 
 *
 * PHP fIle for sending public/private links via email
 * 
 * 
 * ===================================================
 * Original Filename: send-email.php
 * Last Modified Date: Wed, 25 Nov 2019
 *
 */
	
	require_once 'init.php';
	

	# Email Forwarding Variables
	$message_content = '';						# Email message content
	$email_success = '';						# Email successfully sent message
	$email_error = '';							# Email error message
	$message_box = '';

	# Check if Send Email Button was clicked
	if (isset($_POST['email-submit'])) {

        	
			# Uploaded Amazon S3 Object URL
			if(isset($_SESSION['file-link'])) {
				$message_file_link = $_SESSION['file-link'];
			} else {
				$message_file_link = "File has not been uploaded.";
			}


			# Uploaded Amazon S3 Object URL Time (Public link will be valid for 1 hour)
			if(isset($_SESSION['url-time'])) {
				$message_file_link_timer = $_SESSION['url-time'];
			} else {
				$message_file_link_timer = 'The file will be available for 1 hour until ' . date('Y-m-d H:i:s', strtotime('1 hour'));;
			}

			
			# Email Message Content Bobdy with S3 Object Link
			$message_content = <<<EOT
						
						-----------------------------------------------------------------------------------------------------------------------------------------------------
						Uploaded File link: 
						(Warning! Download the file only if you were expecting to receive it, we don't take any responsibility for the content of the file)
						-----------------------------------------------------------------------------------------------------------------------------------------------------
						
						$message_file_link\n						
						EOT;



			# Check if Email was included in the Form field
			if (isset($_POST['form-email'])) {
				
				$email_to = '';
				$email_from = 'XXXXXXXXXXXXXXXXXXXX';					# *****INCLUDE YOUR EMAIL ADDRESS*****


				$general_email_expression = '/^[A-Za-z0-9._%-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,4}$/';
				

				# Check if email structure is valid
  				if(preg_match($general_email_expression, $_POST['form-email']) == 0) {

  					$email_error = 'The email address you entered is not valid. Make sure your email is correct.';
  					$message_box = "error";

  				} else {


  					function clean_string($string) {

						$bad = array("content-type","bcc:","to:","cc:","href");
						return str_replace($bad,"",$string);

					}


  					# Assign Receiver's email address
  					$filtered_email = filter_input(INPUT_POST, 'form-email', FILTER_SANITIZE_STRING);
  					$email_to = clean_string($filtered_email);  					


  					# Assign Receiver's name (optional)
					if (isset($_POST['form-name'])) {

						$email_subject = 'File Link shared by ' . filter_input(INPUT_POST, 'form-name', FILTER_SANITIZE_STRING);
						$email_sender_name = filter_input(INPUT_POST, 'form-name', FILTER_SANITIZE_STRING);

					} else {

						$email_subject = 'File Link uploaded at XXXXXXXXXXXX';			# YOU CAN INCLUDE YOUR SITE NAME
						$email_sender_name = '';

					}
					

					# User Submitted Message (optional)
					if (isset($_POST['form-content'])) {

						$email_user_message = filter_input(INPUT_POST, 'form-content', FILTER_SANITIZE_STRING);

					} else {

						$email_user_message = '';

					}


					# Custom Email Body 
					$email_body = "Hello " . $email_sender_name . 
								  ",\n\nA file has been uploaded by you or for you via our portal. \n\n" . 
								  "Sender message: " . $email_user_message . "\n" 
								  . $message_content . "\n" 
								  . $message_file_link_timer . 
								  "\n\nThank you for using our service!";


					# Email Sender (update accordingly)
					$email_header = 'From: ' . $email_from . "\r\n".
									'Reply-To: ' . $email_from . "\r\n" .
									'X-Mailer: PHP/' . phpversion();


					# Google reCaptcha v2 Check
					if(isset($_POST['g-recaptcha-response']) && !empty($_POST['g-recaptcha-response'])) {

						# Your Secret Key
        				$secret = 'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX';				# ***** INCLUDE YOUR reCAPTCHA SECRET KEY *****

        				$verifyResponse = file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret='.$secret.'&response='.$_POST['g-recaptcha-response']);

        				$responseData = json_decode($verifyResponse);
        				
        				# If reCaptcha returned success
        				if($responseData->success) {

							# Send Email
							if (mail($email_to, $email_subject, $email_body, $email_header)) {

								$email_success = "Email has been sent successfully.";
								$message_box_success = "success";

								$_SESSION = array(); # Clean session variables

							} else {

								$email_error = "There was an error, please try again.";
								$message_box = "error";
							}

						# If reCaptch was not successfule
						} 

   					} # End # Google reCaptcha v2 Check


				}

			} # End Check if Email was included in the Form field

			
	}



 ?>