<?php
/*

 * Copyright (c) 2019 Berkine Design

 * ===================================================

 * 

 *

 * Main PHP File to send file to Amazon S3 bucket

 * Also allows to send public/private links via email

 * 

 * 

 * ===================================================

 * Original Filename: single-file-upload.php

 * Last Modified Date: Wed, 25 Nov 2019

 *

 */

	

	# Include AWS S3 credentials and parameters

	require 'configs/start.php';

	require_once 'init.php';

	



	use Aws\S3\S3Client;  

	use Aws\Exception\AwsException;

	use Aws\Exception\CredentialsException;





	# Single File Upload Variables

	$public_url = 's3://dtpic/test/';					# Public file link

	$private_url = '';					# Private file link

	$private_url_duration = '';			# Private file link duration (valid only for set time)

	

	# Response for AJAX Request

	$response_array = [];

	

	

	# Maximum allowed file size to upload - can be changed as needed (make sure PHP ini file is updated accordingly)

	# Single File Upload size limit is set as 5 MB in Bytes

	$file_size_limit = 5242880;





	#============================================================================================

	#

	# Main Code for sending SINGLE FILE to Amazon S3 bucket and generating public/private links

	#

	#============================================================================================



	# Check if Single File is selected for File Upload

	if(isset($_FILES['single-file'])) {





		# Verify that file does not exceed maximum allowed size (also checked via JS to avoid extra load on the server)

		if ($_FILES['single-file']['size'] > $file_size_limit) {



			$single_error_message = "Please select a file less than 5 MB in size.";			

		

		# If file within the allowed size, proceed with uplaoding to Amazon S3 Bucket

		} else {





			# File Specifications (Name, Size, TempName, Extension)

			$file_name = $_FILES['single-file']['name'];				  

			$file_size = $_FILES['single-file']['size'];

			$file_tmp_name = $_FILES['single-file']['tmp_name'];

			$file_extension = explode('.', $file_name);

			$file_extension = strtolower(end($file_extension));





				try {





					# If "Public S3 File Link" radio button was selected:

					# ===================================================

					if ($_POST['radiobutton'] === 'public-link') {

						

							

							# Upload to Amazon S3 Bucket

							$result = $s3 -> putObject([

								'Bucket' => $config['s3']['bucketName'],	# Bucket Name

								'Key' => "test/{$file_name}",				# S3 Object Name

								'SourceFile' => $file_tmp_name,					# S3 Object Content

								'ServerSideEncryption' => 'AES256',			# Server Side Encryption (optional)

								'StorageClass' => 'STANDARD',  	# S3 Storage Type - Can be one of the follwoing: STANDARD|REDUCED_REDUNDANCY|GLACIER|STANDARD_IA|ONEZONE_IA|INTELLIGENT_TIERING|DEEP_ARCHIVE 

								'ACL' => 'public-read', 					# S3 Object Access Control List - Can be one of the following: private|public-read|public-read-write|authenticated-read|aws-exec-read|bucket-owner-read|bucket-owner-full-control

								'ContentDisposition' => 'attachment'		# Allows you to download the file without opening it in the browser

							]);



			

							# Status of the S3 upload (returns 200 if uploaded successfully)

							$status_code = $result['@metadata']['statusCode'];



				

							# If successfully uploaded to S3 Bucket

							if ($status_code === 200) {



								# Public URL of the Upload S3 object

								$public_url = $result['@metadata']['effectiveUri'];

								

	

								# Store as a session variable (needed for attaching to the email)

								$_SESSION['file-link'] = $public_url;

								



								# Return Results

								$response_array['public-url'] = $public_url;

								$response_array['message'] = 'File Successfully Uploaded.';

								$response_array['status'] = 'success';

								

								header('Content-type: application/json');

								echo json_encode($response_array, JSON_UNESCAPED_SLASHES);		



							} else {



								$response_array['message'] = 'There was an Error during File Upload.';

								$response_array['status'] = 'error';

								

								header('Content-type: application/json');

								echo json_encode($response_array, JSON_UNESCAPED_SLASHES);



							}



													



					# If "Private S3 File Link" radio button was selected:

					# ====================================================

					} elseif ($_POST['radiobutton'] === 'private-link') {

					



							# Upload to Amazon S3 Bucket

							$result = $s3 -> putObject([

								'Bucket' => $config['s3']['bucketName'],	# Bucket Name

								'Key' => "codecanyon-s3/{$file_name}",				# S3 Object Name

								'SourceFile' => $file_tmp_name,					# S3 Object Content

								'ServerSideEncryption' => 'AES256',			# Server Side Encryption (optional)

								'StorageClass' => 'STANDARD', 	# S3 Storage Type - Can be one of the follwoing: 'STANDARD|REDUCED_REDUNDANCY|GLACIER|STANDARD_IA|ONEZONE_IA|INTELLIGENT_TIERING|DEEP_ARCHIVE'

								'ContentDisposition' => 'attachment'		# Allows you to download the file without opening it in the browser

							]);



							

							# Status of the S3 upload (returns 200 if uploaded successfully)

							$status_code = $result['@metadata']['statusCode'];

							

							

							# If successfully uploaded to S3 Bucket

							if ($status_code === 200) {

								

								# Return uploaded S3 object

								$s3_object = $s3 -> getCommand('GetObject',[

									'Bucket' => $config['s3']['bucketName'],

									'Key' => "codecanyon-s3/{$file_name}"

								]);

								



								# Create S3 Object Presigned Private URL with expiration time

								$request = $s3->createPresignedRequest($s3_object , strtotime($_POST['timer'] . ' minutes'));





								# Return URL of the S3 Object with Presigned Private URL

								$presigned_url = (string)$request->getUri();

								$private_url = $presigned_url;



								

								# Time notification until which private link is valid

								$time = date('Y-m-d H:i:s', strtotime($_POST['timer'] . ' minute'));

								





								# Time notification message for the user

								$private_url_duration = "*Private link valid for " . $_POST['timer'] . " minutes until " . $time . " GMT+1";							





								# Return Results

								$response_array['private-url'] = $private_url;

								$response_array['private-url-duration'] = $private_url_duration;

								$response_array['message'] = 'File Successfully Uploaded.';	

								$response_array['status'] = 'success';

								



								header('Content-type: application/json');

								echo json_encode($response_array, JSON_UNESCAPED_SLASHES);



								# Store as session variables (needed for attaching to the email)

								$_SESSION['file-link'] = $private_url;

								$_SESSION['url-time'] = $private_url_duration;

								



							} else {



								$response_array['message'] = 'File was Not Uploaded Successfully.';

								$response_array['status'] = 'error';

								

								header('Content-type: application/json');

								echo json_encode($response_array, JSON_UNESCAPED_SLASHES);



							}

				

					} else {



						die('No Option has been selected');



					}





				} catch (S3Exception $e) {



						$response_array['message'] = 'There was an error: ' + $e->getAwsErrorType();

						$response_array['status'] = 'error';

						

						header('Content-type: application/json');

						echo json_encode($response_array, JSON_UNESCAPED_SLASHES);						



				} catch (InvalidArgumentException $e) {



					 	$response_array['message'] = 'There was an error: ' + $e->getAwsErrorType();

						$response_array['status'] = 'error';

						

						header('Content-type: application/json');

						echo json_encode($response_array, JSON_UNESCAPED_SLASHES);



				} catch (CredentialsException $e) {



						$response_array['message'] = 'There was an error: ' + $e->getAwsErrorType();

						$response_array['status'] = 'error';

						

						header('Content-type: application/json');

						echo json_encode($response_array, JSON_UNESCAPED_SLASHES);

				}



		} 





		

	# In case if no file was selected (Handled by JS initially as well)

	} elseif (!empty($_POST['upload-submit']) && !isset($_FILES['single-file'])) {



			$response_array['message'] = 'There was no file selected.';

			$response_array['status'] = 'error';

			

			header('Content-type: application/json');

			echo json_encode($response_array, JSON_UNESCAPED_SLASHES);



	} 











	

	

?>	